/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.IPCManagerEvent;
import com.cisco.pt.ipc.events.IPCManagerEventListener;
import com.cisco.pt.ipc.system.IPCManager;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCManagerEventRegistry
extends IPCEventRegistry {
    protected Set<IPCManagerEventListener> globalListeners = new HashSet<IPCManagerEventListener>();
    protected Map<String, Set<IPCManagerEventListener>> specificObjectListeners = new HashMap<String, Set<IPCManagerEventListener>>();
    private static Log logger = LogFactory.getLog(IPCManagerEventRegistry.class);

    public IPCManagerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "IpcManager";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        IPCManagerEvent evt = null;
        if (eventName.equalsIgnoreCase("onSave")) {
            evt = new IPCManagerEvent.OnSave(event);
        } else if (eventName.equalsIgnoreCase("onOpen")) {
            evt = new IPCManagerEvent.OnOpen(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (IPCManagerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<IPCManagerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (IPCManagerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(IPCManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("onSave");
                this.register("onOpen");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(IPCManagerEventListener listener, IPCManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IPCManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<IPCManagerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "onSave");
                this.register(uuid, "onOpen");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(IPCManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("onSave");
                this.deregister("onOpen");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(IPCManagerEventListener listener, IPCManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<IPCManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "onSave");
            this.deregister(uuid, "onOpen");
            specificListeners.remove(listener);
        }
    }

    public void addListener(IPCManagerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(IPCManagerEventListener listener, IPCManager objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(IPCManagerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(IPCManagerEventListener listener, IPCManager objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

